function shuffleColors(t) {
    var e, s, i;
    for (i = t.length - 1; i > 0; i--) e = Math.floor(Math.random() * (i + 1)), s = t[i], t[i] = t[e], t[e] = s
}

function startGame() {
    var t = new Phaser.Game(480, 800, Phaser.CANVAS, "", null);
    t.gameMode = 0, t.state.add("Boot", Gam.Boot), t.state.add("Preloader", Gam.Preloader), t.state.add("Menu", Gam.Menu), t.state.add("GameMenu", Gam.GameMenu), t.state.add("Game", Gam.Game), t.state.add("Editor", Gam.Editor), t.state.start("Boot"), window.game = t
}


var Gam = {};
Gam.Config = {}, Gam.Config.sound = !0, Gam.Config.animations = !0, Gam.Config.gameType = "bubblelevels", Gam.Config.font = "Roboto,sans-serif,Arial", Gam.Config.scores = [], Gam.Config.android = !!window.cordova, Gam.Sfx = function() {}, Gam.Sfx.prototype = {
    load: function() {
        Gam.Config.android ? (this.pop = new Media("/android_asset/www/assets/sfx/pop.ogg", null, null), this.error = new Media("/android_asset/www/assets/sfx/er.ogg", null, null), this.movedown = new Media("/android_asset/www/assets/sfx/movedown.ogg", null, null), this.button = new Media("/android_asset/www/assets/sfx/button.ogg", null, null)) : (game.load.audio("pop", "../assets/sfx/pop.mp3"), game.load.audio("error", "../assets/sfx/er.mp3"), game.load.audio("movedown", "../assets/sfx/movedown.mp3"), game.load.audio("button", "../assets/sfx/button.mp3"))
    },
    create: function() {
        Gam.Config.android || (this.pop = game.add.audio("pop"), this.error = game.add.audio("error"), this.movedown = game.add.audio("movedown"), this.button = game.add.audio("button"))
    },
    play: function(t) {
        game.user.sound && ("pop" == t ? this.pop.play() : "error" == t ? this.error.play() : "movedown" == t ? this.movedown.play() : "button" == t && this.button.play())
    }
}, Gam.Boot = function(t) {}, Gam.Boot.prototype = {
    preload: function() {
        this.load.image("loadingBar", "../assets/loadingbar.png")
    },
    create: function() {
        this.input.maxPointers = 1, this.stage.disableVisibilityChange = !1, this.stage.backgroundColor = 10459345, game.tweens.frameBased = !1, game.time.advancedTiming = !0, game.forceSingleUpdate = !0, game.scale.scaleMode = Phaser.ScaleManager.SHOW_ALL, game.scale.pageAlignHorizontally = !0, game.scale.pageAlignVertically = !0, game.sfx = new Gam.Sfx, Gam.s.add("onNewGame", "onRestart", "onScores", "onGameOver", "onSettings", "onSound", "onMessage", "onColor", "onLevelClear", "onNextLevel", "onVictory", "onDialogOpen", "onDialogClose"), Gam.Local.loadUser(), this.game.state.start("Preloader")
    }
}, Gam.Preloader = function(t) {}, Gam.Preloader.prototype = {
    preload: function() {
        this.game.stage.backgroundColor = "#000000";
        var t = game.add.text(game.width / 2, 400, "Loading");
        t.anchor.set(.5), t.font = Gam.Config.font, t.fontSize = 30, t.fill = "#ffffff", this.preloadBar = this.add.sprite(90, 300, "loadingBar"), this.preloadBar.x = this.game.width / 2 - this.preloadBar.width / 2, this.load.setPreloadSprite(this.preloadBar), this.load.image("bg", "../assets/bg.png"), this.load.atlas("bubbles", "../assets/bubbles.png", "../assets/bubbles.json"), this.load.atlas("sprites", "../assets/spritesheet.png", "../assets/spritesheet.json"), this.load.atlas("ui", "../assets/ui.png", "../assets/ui.json"), game.sfx.load()
    },
    u: function() {
        if (Gam.Config.android) return !0;
        var t = document.URL;
        return !(0 !== t.indexOf("") && !t.indexOf("") && 0 !== t.indexOf(""))
    },
    create: function() {
        game.sfx.create(), this.u() && this.game.state.start("Menu")
    }
}, Gam.n = function(t) {
    return t
}, Gam.s = {
    clearOnStageChange: !1,
    add: function() {
        for (var t = Array.isArray(arguments[0]) ? arguments[0] : arguments, e = 0, s = t.length; e < s; e++) this[t[e]] || (this[t[e]] = new Phaser.Signal);
        this.clearOnStageChange || game.state.onStateChange.add(this.clear, this)
    },
    clear: function() {
        Object.keys(this).forEach(function(t) {
            this[t].removeNonPermanent && this[t].removeNonPermanent()
        }, this)
    }
}, Gam.Local = {
    getUser: function() {
        return {
            sound: !0,
            color: 1,
            plays: 0,
            level: 1,
            score: 0,
            arcadeLevel: 1,
            arcadeScore: 0,
            rate: !1
        }
    },
    saveScore: function(t) {
        game.user.score += t, this.saveUser()
    },
    saveUser: function() {
        localStorage.setItem("shootbubble", JSON.stringify(game.user))
    },
    loadUser: function() {
        var t = localStorage.getItem("shootbubble");
        game.user = t ? JSON.parse(t) : this.getUser()
    },
    clear: function() {
        game.user = this.getUser(), this.saveUser()
    }
}, Gam.Bubble = function(t, e, s) {
    Phaser.Image.call(this, game, t, e, "bubbles"), this.anchor.setTo(.5, .5), this.color = s, Gam.loadTexture(this, "b" + s, "bubbles"), this.scale.set(1)
}, Gam.Bubble.prototype = Object.create(Phaser.Image.prototype), Gam.Bubble.prototype.constructor = Gam.Bubble, Gam.Bubble.prototype.setColor = function(t) {
    this.color = t, Gam.loadTexture(this, "b" + t, "bubbles")
}, Gam.Bubble.prototype.freeze = function() {
    Gam.loadTexture(this, "freeze", "bubbles")
}, Gam.Explosion = function(t, e, s) {
    Phaser.Image.call(this, game, t, e), this.anchor.setTo(.5, .5), this.color = s, this.dx = .5 - Math.random(), this.dy = -Math.random() - .5, Gam.loadTexture(this, "b" + s, "bubbles")
}, Gam.Explosion.prototype = Object.create(Phaser.Image.prototype), Gam.Explosion.prototype.constructor = Gam.Bubble, Gam.Explosion.prototype.setColor = function(t) {
    this.color = t, this.scale.set(1), Gam.loadTexture(this, "b" + t, "bubbles"), this.dx = .5 - Math.random(), this.dy = -Math.random() - .5
}, Gam.Explosion.prototype.update = function() {
    this.alive && (this.x += this.dx * game.time.elapsed, this.y += this.dy * game.time.elapsed, this.dy += .004 * game.time.elapsed, this.y > 800 && this.kill())
}, Gam.BUBBLEWIDTH = 60, Gam.BUBBLEHEIGHT = 50, Gam.BUBBLEHALFWIDTH = Gam.BUBBLEWIDTH / 2, Gam.BUBBLEHALFHEIGHT = Gam.BUBBLEHEIGHT / 2, Gam.BOARDX = 480 - Gam.BUBBLEHALFWIDTH, Gam.BOARDY = 690, Gam.COLORS = [1, 2, 3, 4, 5, 6, 7, 8, 9], Gam.Board = function() {
    Phaser.Group.call(this, game), this.x = -2, this.y = 0, this.line = game.make.image(1, -1, "ui", "line"), this.line.anchor.set(0, 1), this.add(this.line), this.SIZEX = 8, this.SIZEY = 13, this.FILL = 0, this.fall = 0, this.explosionBoard = new Gam.ExplosionBoard, this.add(this.explosionBoard), this.movingBubble = null, this.bubbles = [], this.speed = 9, this.cluster = [], this.previewColor = 1, this.gameOverQueue = [], this.gameOverCounter = 0, this.deleteCluster = [], this.colors = [], this.rowDown = !1, this.rowDownCounter = 0;
    for (var t = 0; t < this.SIZEY + 1; t++) {
        this.bubbles[t] = [];
        var e = this.SIZEX;
        t % 2 == 1 && e--;
        for (var s = 0; s < e; s++) this.bubbles[t][s] = null
    }
}, Gam.Board.prototype = Object.create(Phaser.Group.prototype), Gam.Board.prototype.constructor = Gam.Board, Gam.Board.prototype.initGame = function() {
    this.loadLevel(), this.rowDown = !1, this.fall = 0, this.rCount = 0, this.rowDownCounter = 0, this.probability = 9, this.missCount = 0
}, Gam.Board.prototype.restart = function() {
    this.clear(), this.initGame()
}, Gam.Board.prototype.clear = function() {
    for (e = 0; e < this.SIZEY; e++)
        for (var t = 0; t < this.SIZEX; t++) this.bubbles[e][t] && (this.bubbles[e][t].kill(), this.bubbles[e][t] = null);
    this.movingBubble && (this.movingBubble.kill(), this.movingBubble = null), this.cluster.splice(0, this.cluster.length), this.deleteCluster.splice(0, this.deleteCluster.length);
    for (var e = 0; e < this.children.length; e++) this.children[e].alive && this.children[e] instanceof Gam.Bubble && this.children[e].kill();
    this.explosionBoard.clear(), this.rowDown = !1, this.rowDownCounter = 0, this.targetY = 0, this.y = 0, this.gameOverQueue.splice(0, this.gameOverQueue.length)
}, Gam.Board.prototype.fireBall = function(t, e) {
    if (null != this.movingBubble) return !1;
    var s = 680 - this.y,
        i = this.getFirstDead();
    return i ? (i.reset(240, s), i.cluster = !1, i.setColor(e)) : (i = new Gam.Bubble(240, s, e), this.add(i)), this.movingBubble = i, this.movingBubble.dx = Math.cos(t), this.movingBubble.dy = Math.sin(t), this.rowDown && (this.rowDownCounter = 0), !0
}, Gam.Board.prototype.update = function() {
    if (game.gameMode == Gam.GameMode.Play) {
        this.y += .008 * game.time.elapsed, this.removeBubbles();
        for (var t = 0; t < this.speed && null != this.movingBubble; t++)
            if (this.movingBubble.x = this.movingBubble.x + this.movingBubble.dx * game.timeDiff * .16, this.movingBubble.x < Gam.BUBBLEHALFWIDTH ? (this.movingBubble.x = Gam.BUBBLEHALFWIDTH, this.movingBubble.dx = -this.movingBubble.dx) : this.movingBubble.x > Gam.BOARDX && (this.movingBubble.x = Gam.BOARDX, this.movingBubble.dx = -this.movingBubble.dx), this.movingBubble.y += this.movingBubble.dy * game.timeDiff * .16, this.checkForCollisions()) {
                this.fixBubble();
                break
            }
        this.explosionBoard.update(), this.checkGameOver() && this.gameOver()
    } else if (game.gameMode === Gam.GameMode.Level || game.gameMode === Gam.GameMode.Victory) this.explosionBoard.update();
    else if (game.gameMode === Gam.GameMode.PreGameOver) {
        this.gameOverCounter += game.time.elapsed;
        var e = this.gameOverQueue.shift();
        e ? e.freeze() : Gam.s.onGameOver.dispatch(), this.gameOverCounter = 0
    }
}, Gam.Board.prototype.dest = function() {}, Gam.Board.prototype.loadLevel = function() {
    shuffleColors(Gam.COLORS), this.level = game.level - 1, this.SIZEY = 20 + 5 * Math.floor(this.level / 10), this.FILL = this.SIZEY - 6;
    var t = 3;
    this.level % 2 && (t = 4), this.level % 8 && (t = 5);
    for (var e = 0; e < this.SIZEY; e++) {
        var s = this.SIZEX;
        e % 2 && s--, this.bubbles[e] || (this.bubbles[e] = []);
        for (var i = 0; i < s; i++)
            if (e < this.FILL)
                if (Math.random() < .8) {
                    var o = Gam.BUBBLEHALFWIDTH + i * Gam.BUBBLEWIDTH;
                    e % 2 && (o += Gam.BUBBLEHALFWIDTH);
                    var a = Gam.BUBBLEHALFHEIGHT + Gam.BUBBLEHEIGHT * e,
                        l = Gam.COLORS[Math.floor(Math.random() * t)],
                        r = this.getFirstDead();
                    r ? (r.reset(o, a), r.setColor(l)) : (r = new Gam.Bubble(o, a, l), this.add(r)), r.i = e, r.j = i, this.bubbles[e][i] = r
                } else this.bubbles[e][i] = null;
        else this.bubbles[e][i] = null
    }
    this.y = (13 - this.SIZEY) * Gam.BUBBLEHEIGHT
}, Gam.Board.prototype.getColor = function() {
    return 1
}, Gam.Board.prototype.getPreviewColor = function() {
    if (this.mapColors(), 0 == this.colors.length) return 1;
    var t = Math.floor(Math.random() * this.colors.length);
    return this.colors[t]
}, Gam.Board.prototype.mapColors = function() {
    this.colors.splice(0, this.colors.length);
    for (var t = 0; t < this.SIZEY; t++)
        for (var e = 0; e < this.SIZEX; e++) this.bubbles[t][e] && this.colors.indexOf(this.bubbles[t][e].color) < 0 && this.colors.push(this.bubbles[t][e].color)
}, Gam.Board.prototype.checkForMatch = function(t, e) {
    this.cluster.push(this.bubbles[t][e]), this.bubbles[t][e].cluster = !0;
    for (var s, i = this.bubbles[t][e].color, o = 0; o < this.cluster.length;) {
        s = this.cluster[o], o++;
        var a = s.i,
            l = s.j;
        l > 0 && this.bubbles[a][l - 1] && this.bubbles[a][l - 1].color == i && !this.bubbles[a][l - 1].cluster && this.bubbles[a][l - 1].world.y > 0 && (this.bubbles[a][l - 1].cluster = !0, this.cluster.push(this.bubbles[a][l - 1])), l < this.SIZEX - 1 && this.bubbles[a][l + 1] && this.bubbles[a][l + 1].color == i && !this.bubbles[a][l + 1].cluster && this.bubbles[a][l + 1].world.y > 0 && (this.bubbles[a][l + 1].cluster = !0, this.cluster.push(this.bubbles[a][l + 1])), a % 2 == 0 ? (a > 0 && (l > 0 && this.bubbles[a - 1][l - 1] && this.bubbles[a - 1][l - 1].color == i && !this.bubbles[a - 1][l - 1].cluster && this.bubbles[a - 1][l - 1].world.y > 0 && (this.bubbles[a - 1][l - 1].cluster = !0, this.cluster.push(this.bubbles[a - 1][l - 1])), this.bubbles[a - 1][l] && this.bubbles[a - 1][l].color == i && !this.bubbles[a - 1][l].cluster && this.bubbles[a - 1][l].world.y > 0 && (this.bubbles[a - 1][l].cluster = !0, this.cluster.push(this.bubbles[a - 1][l]))), a < this.SIZEY - 1 && (l > 0 && this.bubbles[a + 1][l - 1] && this.bubbles[a + 1][l - 1].color == i && !this.bubbles[a + 1][l - 1].cluster && this.bubbles[a + 1][l - 1].world.y > 0 && (this.bubbles[a + 1][l - 1].cluster = !0, this.cluster.push(this.bubbles[a + 1][l - 1])), this.bubbles[a + 1][l] && this.bubbles[a + 1][l].color == i && !this.bubbles[a + 1][l].cluster && this.bubbles[a + 1][l].world.y > 0 && (this.bubbles[a + 1][l].cluster = !0, this.cluster.push(this.bubbles[a + 1][l])))) : (a > 0 && (l < this.SIZEX - 1 && this.bubbles[a - 1][l + 1] && this.bubbles[a - 1][l + 1].color == i && !this.bubbles[a - 1][l + 1].cluster && this.bubbles[a - 1][l + 1].world.y > 0 && (this.bubbles[a - 1][l + 1].cluster = !0, this.cluster.push(this.bubbles[a - 1][l + 1])), this.bubbles[a - 1][l] && this.bubbles[a - 1][l].color == i && !this.bubbles[a - 1][l].cluster && this.bubbles[a - 1][l].world.y > 0 && (this.bubbles[a - 1][l].cluster = !0, this.cluster.push(this.bubbles[a - 1][l]))), a < this.SIZEY - 1 && (l < this.SIZEX - 1 && this.bubbles[a + 1][l + 1] && this.bubbles[a + 1][l + 1].color == i && !this.bubbles[a + 1][l + 1].cluster && this.bubbles[a + 1][l + 1].world.y > 0 && (this.bubbles[a + 1][l + 1].cluster = !0, this.cluster.push(this.bubbles[a + 1][l + 1])), this.bubbles[a + 1][l] && this.bubbles[a + 1][l].color == i && !this.bubbles[a + 1][l].cluster && this.bubbles[a + 1][l].world.y > 0 && (this.bubbles[a + 1][l].cluster = !0, this.cluster.push(this.bubbles[a + 1][l]))))
    }
    if (this.cluster.length > 2) {
        var r = this.removeCluster(),
            h = this.checkForFree();
        game.p.onPoints(r + h)
    } else this.checkGameOver() || (game.sfx.play("error"), this.clearCluster(), this.checkRowDown())
}, Gam.Board.prototype.startFlick = function() {}, Gam.Board.prototype.flick = function() {}, Gam.Board.prototype.checkRowDown = function() {
    this.missCount < 2 ? this.missCount++ : this.missCount < 3 ? this.missCount++ : Math.floor(100 * Math.random()) < this.probability || this.missCount > 8 ? (this.rowDown ? this.rowDownCounter += 50 : (this.rowDown = !0, this.rowDownCounter = 0), this.missCount = 0) : this.missCount++
}, Gam.Board.prototype.removeBubbles = function() {
    for (; this.deleteCluster.length > 0;) {
        var t = this.deleteCluster.shift();
        t && (this.explosionBoard.addExplosion(t.x, t.y, t.color), t.kill(), game.sfx.play("pop")), 0 == this.deleteCluster.length && this.checkVictory()
    }
}, Gam.Board.prototype.checkForFree = function() {
    var t = -Math.floor(this.y / Gam.BUBBLEHEIGHT) - 1;
    t < 0 && (t = 0);
    for (a = 0; a < this.SIZEX; a++) this.bubbles[t][a] && (this.bubbles[t][a].cluster = !0, this.cluster.push(this.bubbles[t][a]));
    for (var e, s = 0; s < this.cluster.length;) e = this.cluster[s], s++, this.pushToClusterAllNeghbours(e.i, e.j);
    for (var i = 0, o = t; o < this.SIZEY; o++)
        for (var a = 0; a < this.SIZEX; a++) this.bubbles[o][a] && !this.bubbles[o][a].cluster && (this.deleteCluster.push(this.bubbles[o][a]), this.bubbles[o][a] = null, i++);
    return this.clearCluster(), i
}, Gam.Board.prototype.pushToClusterAllNeghbours = function(t, e) {
    e > 0 && this.bubbles[t][e - 1] && !this.bubbles[t][e - 1].cluster && this.bubbles[t][e - 1].world.y > 0 && (this.bubbles[t][e - 1].cluster = !0, this.cluster.push(this.bubbles[t][e - 1])), e < this.SIZEX - 1 && this.bubbles[t][e + 1] && !this.bubbles[t][e + 1].cluster && this.bubbles[t][e + 1].world.y > 0 && (this.bubbles[t][e + 1].cluster = !0, this.cluster.push(this.bubbles[t][e + 1])), t % 2 == 0 ? (t > 0 && (e > 0 && this.bubbles[t - 1][e - 1] && !this.bubbles[t - 1][e - 1].cluster && this.bubbles[t - 1][e - 1].world.y > 0 && (this.bubbles[t - 1][e - 1].cluster = !0, this.cluster.push(this.bubbles[t - 1][e - 1])), this.bubbles[t - 1][e] && !this.bubbles[t - 1][e].cluster && this.bubbles[t - 1][e].world.y > 0 && (this.bubbles[t - 1][e].cluster = !0, this.cluster.push(this.bubbles[t - 1][e]))), t < this.SIZEY - 1 && (e > 0 && this.bubbles[t + 1][e - 1] && !this.bubbles[t + 1][e - 1].cluster && this.bubbles[t + 1][e - 1].world.y > 0 && (this.bubbles[t + 1][e - 1].cluster = !0, this.cluster.push(this.bubbles[t + 1][e - 1])), this.bubbles[t + 1][e] && !this.bubbles[t + 1][e].cluster && this.bubbles[t + 1][e].world.y > 0 && (this.bubbles[t + 1][e].cluster = !0, this.cluster.push(this.bubbles[t + 1][e])))) : (t > 0 && (e < this.SIZEX - 1 && this.bubbles[t - 1][e + 1] && !this.bubbles[t - 1][e + 1].cluster && this.bubbles[t - 1][e + 1].world.y > 0 && (this.bubbles[t - 1][e + 1].cluster = !0, this.cluster.push(this.bubbles[t - 1][e + 1])), this.bubbles[t - 1][e] && !this.bubbles[t - 1][e].cluster && this.bubbles[t - 1][e].world.y > 0 && (this.bubbles[t - 1][e].cluster = !0, this.cluster.push(this.bubbles[t - 1][e]))), t < this.SIZEY - 1 && (e < this.SIZEX - 1 && this.bubbles[t + 1][e + 1] && !this.bubbles[t + 1][e + 1].cluster && this.bubbles[t + 1][e + 1].world.y > 0 && (this.bubbles[t + 1][e + 1].cluster = !0, this.cluster.push(this.bubbles[t + 1][e + 1])), this.bubbles[t + 1][e] && !this.bubbles[t + 1][e].cluster && this.bubbles[t + 1][e].world.y > 0 && (this.bubbles[t + 1][e].cluster = !0, this.cluster.push(this.bubbles[t + 1][e]))))
}, Gam.Board.prototype.removeCluster = function() {
    for (var t = 0; t < this.SIZEY; t++)
        for (var e = 0; e < this.SIZEX; e++) this.bubbles[t][e] && this.bubbles[t][e].cluster && (this.bubbles[t][e].cluster = !1, this.bubbles[t][e] = null, 0 == t && !0);
    this.deleteCluster.push.apply(this.deleteCluster, this.cluster);
    var s = this.cluster.length;
    return this.cluster.splice(0, this.cluster.length), s
}, Gam.Board.prototype.clearCluster = function() {
    for (var t = 0; t < this.SIZEY; t++)
        for (var e = 0; e < this.SIZEX; e++) this.bubbles[t][e] && this.bubbles[t][e].cluster && (this.bubbles[t][e].cluster = !1);
    this.cluster.splice(0, this.cluster.length)
}, Gam.Board.prototype.checkNext = function() {
    this.newX = this.movingBubble.x * this.movingBubble.dx * Gam.BUBBLEHALFWIDTH
}, Gam.Board.prototype.checkForCollisions = function() {
    if (this.movingBubble.y < Gam.BUBBLEHALFHEIGHT / 2) return !0;
    Math.floor(this.movingBubble.y / Gam.BUBBLEHEIGHT) % 2 ? Math.floor(this.movingBubble.x / Gam.BUBBLEWIDTH) >= this.SIZEX && this.SIZEX : Math.floor((this.movingBubble.x + Gam.BUBBLEHALFWIDTH) / Gam.BUBBLEWIDTH) >= this.SIZEX && this.SIZEX;
    for (var t = 0; t < this.SIZEY; t++)
        for (var e = 0; e < this.SIZEX; e++)
            if (this.bubbles[t][e]) {
                var s = Math.abs(this.bubbles[t][e].x - this.movingBubble.x),
                    i = Math.abs(this.bubbles[t][e].y - this.movingBubble.y);
                if (s < Gam.BUBBLEWIDTH && i < Gam.BUBBLEHEIGHT && Math.sqrt(s * s + i * i) < 50) return !0
            }
    return !1
}, Gam.Board.prototype.hasColor = function(t) {
    return this.mapColors(), this.colors.indexOf(t) > -1
}, Gam.Board.prototype.checkVictory = function() {
    for (var t = 0; t < this.SIZEX; t++)
        if (this.bubbles[0][t]) return !1;
    Gam.s.onLevelClear.dispatch()
}, Gam.Board.prototype.onRowDown = function() {
    this.movingDown = !0, this.rowDown = !1, this.targetY = this.y + Gam.BUBBLEHEIGHT, game.sfx.play("movedown")
}, Gam.Board.prototype.checkGameOver = function() {
    var t = 12 - Math.floor(this.y / Gam.BUBBLEHEIGHT);
    if (t >= this.SIZEY) return !1;
    for (var e = t; e < this.SIZEY; e++)
        for (var s = 0; s < this.SIZEX; s++)
            if (this.bubbles[e][s]) return this.gameOver(), !0;
    return !1
}, Gam.Board.prototype.gameOver = function() {
    game.gameMode = Gam.GameMode.PreGameOver;
    for (var t = this.SIZEY - 1; t >= 0; t--)
        for (var e = 0; e < this.SIZEX; e++) this.bubbles[t][e] && this.gameOverQueue.push(this.bubbles[t][e]);
    this.gameOverCounter = 0
}, Gam.Board.prototype.fixBubble = function() {
    var t = Math.floor(this.movingBubble.y / Gam.BUBBLEHEIGHT),
        e = 0;
    e = t % 2 ? Math.floor((this.movingBubble.x - Gam.BUBBLEHALFWIDTH) / Gam.BUBBLEWIDTH) : Math.floor(this.movingBubble.x / Gam.BUBBLEWIDTH), t < 0 && (t = 0), e < 0 && (e = 0), e >= this.SIZEX && (e = this.SIZEX - 1), null != this.bubbles[t][e] ? t == this.SIZEY ? this.gameOver() : (console.log(t + " " + e), this.movingBubble.kill(), this.movingBubble = null, game.p.onBall()) : (this.bubbles[t][e] = this.movingBubble, this.movingBubble.y = t * Gam.BUBBLEHEIGHT + Gam.BUBBLEHALFHEIGHT, this.movingBubble.x = t % 2 ? Gam.BUBBLEWIDTH * e + Gam.BUBBLEWIDTH : Gam.BUBBLEWIDTH * e + Gam.BUBBLEHALFWIDTH, this.movingBubble.i = t, this.movingBubble.j = e, this.movingBubble = null, this.checkForMatch(t, e), game.p.onBall())
}, Gam.ExplosionBoard = function() {
    Phaser.Group.call(this, game)
}, Gam.ExplosionBoard.prototype = Object.create(Phaser.Group.prototype), Gam.ExplosionBoard.prototype.addExplosion = function(t, e, s) {
    var i = this.getFirstDead();
    i ? (i.reset(t, e), i.setColor(s)) : (i = new Gam.Explosion(t, e, s), this.add(i)), i.scale.set(1)
}, Gam.ExplosionBoard.prototype.update = function() {
    for (var t = 0; t < this.children.length; t++) this.children[t].alive && this.children[t].update()
}, Gam.ExplosionBoard.prototype.clear = function() {
    for (var t = 0; t < this.children.length; t++) this.children[t].alive && this.children[t].kill()
}, Gam.makeImage = function(t, e, s, i, o, a) {
    var l;
    return l = a ? game.make.image(t, e, a, s) : game.make.image(t, e, s), i && ("number" == typeof i ? l.anchor.setTo(i) : l.anchor.setTo(i[0], i[1])), o ? (o.add || o.addChild).call(o, l) : null !== o && game.world.add(l), l
}, Gam.BoardPuz = function() {
    Phaser.Group.call(this, game), this.x = -2, this.y = 0, this.line = game.make.image(1, -1, "ui", "line"), this.line.anchor.set(0, 1), this.add(this.line), this.SIZEX = 8, this.SIZEY = 13, this.FILL = 0, this.fall = 0, this.explosionBoard = new Gam.ExplosionBoard, this.add(this.explosionBoard), this.movingBubble = null, this.bubbles = [], this.speed = 9, this.cluster = [], this.previewColor = 1, this.gameOverQueue = [], this.gameOverCounter = 0, this.deleteCluster = [], this.colors = [], this.rowDown = !1, this.rowDownCounter = 0;
    for (var t = 0; t < this.SIZEY + 1; t++) {
        this.bubbles[t] = [];
        var e = this.SIZEX;
        t % 2 == 1 && e--;
        for (var s = 0; s < e; s++) this.bubbles[t][s] = null
    }
}, Gam.BoardPuz.prototype = Object.create(Phaser.Group.prototype), Gam.BoardPuz.prototype.constructor = Gam.BoardPuz, Gam.BoardPuz.prototype.initGame = function() {
    this.loadLevel(), this.rowDown = !1, this.fall = 0, this.y = 0, this.rCount = 0, this.rowDownCounter = 0, this.probability = 9, this.missCount = 0
}, Gam.BoardPuz.prototype.restart = function() {
    this.clear(), this.initGame()
}, Gam.BoardPuz.prototype.clear = function() {
    for (e = 0; e < this.SIZEY + 1; e++)
        for (var t = 0; t < this.SIZEX; t++) this.bubbles[e][t] && (this.bubbles[e][t].kill(), this.bubbles[e][t] = null);
    this.movingBubble && (this.movingBubble.kill(), this.movingBubble = null), this.cluster.splice(0, this.cluster.length), this.deleteCluster.splice(0, this.deleteCluster.length);
    for (var e = 0; e < this.children.length; e++) this.children[e].alive && this.children[e] instanceof Gam.Bubble && this.children[e].kill();
    this.explosionBoard.clear(), this.rowDown = !1, this.rowDownCounter = 0, this.targetY = 0, this.y = 0, this.gameOverQueue.splice(0, this.gameOverQueue.length)
}, Gam.BoardPuz.prototype.fireBall = function(t, e) {
    if (null != this.movingBubble) return !1;
    var s = 680 - this.fall * Gam.BUBBLEHEIGHT,
        i = this.getFirstDead();
    return i ? (i.reset(240, s), i.cluster = !1, i.setColor(e)) : (i = new Gam.Bubble(240, s, e), this.add(i)), this.movingBubble = i, this.movingBubble.dx = Math.cos(t), this.movingBubble.dy = Math.sin(t), this.rowDown && (this.rowDownCounter = 0), !0
}, Gam.BoardPuz.prototype.update = function() {
    if (game.gameMode == Gam.GameMode.Play) {
        if (this.movingDown && (this.y += .2 * game.time.elapsed, this.y >= this.targetY && (this.y = this.targetY, this.movingDown = !1, this.fall++, this.checkGameOver()))) return void this.gameOver();
        this.rowDown && (this.rowDownCounter += game.timeDiff, this.rowDownCounter > 30 && null == this.movingBubble && (this.onRowDown(), this.rowDown = !1, this.rowDownCounter = 0)), this.removeBubbles();
        for (var t = 0; t < this.speed && null != this.movingBubble; t++)
            if (this.movingBubble.x = this.movingBubble.x + this.movingBubble.dx * game.timeDiff * .16, this.movingBubble.x < Gam.BUBBLEHALFWIDTH ? (this.movingBubble.x = Gam.BUBBLEHALFWIDTH, this.movingBubble.dx = -this.movingBubble.dx) : this.movingBubble.x > Gam.BOARDX && (this.movingBubble.x = Gam.BOARDX, this.movingBubble.dx = -this.movingBubble.dx), this.movingBubble.y += this.movingBubble.dy * game.timeDiff * .16, this.checkForCollisions()) {
                this.fixBubble();
                break
            }
        this.explosionBoard.update()
    } else if (game.gameMode === Gam.GameMode.Level || game.gameMode === Gam.GameMode.Victory) this.explosionBoard.update();
    else if (game.gameMode === Gam.GameMode.PreGameOver) {
        this.gameOverCounter += game.time.elapsed;
        var e = this.gameOverQueue.shift();
        e ? e.freeze() : Gam.s.onGameOver.dispatch(), this.gameOverCounter = 0
    }
}, Gam.BoardPuz.prototype.dest = function() {}, Gam.BoardPuz.prototype.loadLevel = function() {
    this.level = game.level - 1;
    for (var t = 0; t < LEVELS[this.level].length; t++)
        for (var e = 0; e < LEVELS[this.level][t].length; e++)
            if (LEVELS[this.level][t][e] > 0) {
                var s = Gam.BUBBLEHALFWIDTH + e * Gam.BUBBLEWIDTH;
                t % 2 && (s += Gam.BUBBLEHALFWIDTH);
                var i = Gam.BUBBLEHALFHEIGHT + Gam.BUBBLEHEIGHT * t,
                    o = LEVELS[this.level][t][e],
                    a = this.getFirstDead();
                a ? (a.reset(s, i), a.setColor(o)) : (a = new Gam.Bubble(s, i, o), this.add(a)), this.bubbles[t][e] = a, a.i = t, a.j = e
            }
}, Gam.BoardPuz.prototype.getColor = function() {
    return 1
}, Gam.BoardPuz.prototype.getPreviewColor = function() {
    if (this.mapColors(), 0 == this.colors.length) return 1;
    var t = Math.floor(Math.random() * this.colors.length);
    return this.colors[t]
}, Gam.BoardPuz.prototype.mapColors = function() {
    this.colors.splice(0, this.colors.length);
    for (var t = 0; t < this.SIZEY; t++)
        for (var e = 0; e < this.SIZEX; e++) this.bubbles[t][e] && this.colors.indexOf(this.bubbles[t][e].color) < 0 && this.colors.push(this.bubbles[t][e].color)
}, Gam.BoardPuz.prototype.checkForMatch = function(t, e) {
    this.cluster.push(this.bubbles[t][e]), this.bubbles[t][e].cluster = !0;
    for (var s, i = this.bubbles[t][e].color, o = 0; o < this.cluster.length;) {
        s = this.cluster[o], o++;
        var a = s.i,
            l = s.j;
        l > 0 && this.bubbles[a][l - 1] && this.bubbles[a][l - 1].color == i && !this.bubbles[a][l - 1].cluster && (this.bubbles[a][l - 1].cluster = !0, this.cluster.push(this.bubbles[a][l - 1])), l < this.SIZEX - 1 && this.bubbles[a][l + 1] && this.bubbles[a][l + 1].color == i && !this.bubbles[a][l + 1].cluster && (this.bubbles[a][l + 1].cluster = !0, this.cluster.push(this.bubbles[a][l + 1])), a % 2 == 0 ? (a > 0 && (l > 0 && this.bubbles[a - 1][l - 1] && this.bubbles[a - 1][l - 1].color == i && !this.bubbles[a - 1][l - 1].cluster && (this.bubbles[a - 1][l - 1].cluster = !0, this.cluster.push(this.bubbles[a - 1][l - 1])), this.bubbles[a - 1][l] && this.bubbles[a - 1][l].color == i && !this.bubbles[a - 1][l].cluster && (this.bubbles[a - 1][l].cluster = !0, this.cluster.push(this.bubbles[a - 1][l]))), a < this.SIZEY - 1 && (l > 0 && this.bubbles[a + 1][l - 1] && this.bubbles[a + 1][l - 1].color == i && !this.bubbles[a + 1][l - 1].cluster && (this.bubbles[a + 1][l - 1].cluster = !0, this.cluster.push(this.bubbles[a + 1][l - 1])), this.bubbles[a + 1][l] && this.bubbles[a + 1][l].color == i && !this.bubbles[a + 1][l].cluster && (this.bubbles[a + 1][l].cluster = !0, this.cluster.push(this.bubbles[a + 1][l])))) : (a > 0 && (l < this.SIZEX - 1 && this.bubbles[a - 1][l + 1] && this.bubbles[a - 1][l + 1].color == i && !this.bubbles[a - 1][l + 1].cluster && (this.bubbles[a - 1][l + 1].cluster = !0, this.cluster.push(this.bubbles[a - 1][l + 1])), this.bubbles[a - 1][l] && this.bubbles[a - 1][l].color == i && !this.bubbles[a - 1][l].cluster && (this.bubbles[a - 1][l].cluster = !0, this.cluster.push(this.bubbles[a - 1][l]))), a < this.SIZEY - 1 && (l < this.SIZEX - 1 && this.bubbles[a + 1][l + 1] && this.bubbles[a + 1][l + 1].color == i && !this.bubbles[a + 1][l + 1].cluster && (this.bubbles[a + 1][l + 1].cluster = !0, this.cluster.push(this.bubbles[a + 1][l + 1])), this.bubbles[a + 1][l] && this.bubbles[a + 1][l].color == i && !this.bubbles[a + 1][l].cluster && (this.bubbles[a + 1][l].cluster = !0, this.cluster.push(this.bubbles[a + 1][l]))))
    }
    if (this.cluster.length > 2) {
        var r = this.removeCluster(),
            h = this.checkForFree();
        game.p.onPoints(r + h)
    } else this.checkGameOver() || (game.sfx.play("error"), this.clearCluster(), this.checkRowDown())
}, Gam.BoardPuz.prototype.startFlick = function() {}, Gam.BoardPuz.prototype.flick = function() {}, Gam.BoardPuz.prototype.checkRowDown = function() {
    console.log("checkRowDown", this.missCount, this.probability), this.missCount < 2 ? this.missCount++ : this.missCount < 3 ? this.missCount++ : Math.floor(100 * Math.random()) < this.probability || this.missCount > 8 ? (this.rowDown ? this.rowDownCounter += 50 : (this.rowDown = !0, this.rowDownCounter = 0), this.missCount = 0) : this.missCount++
}, Gam.BoardPuz.prototype.removeBubbles = function() {
    for (; this.deleteCluster.length > 0;) {
        var t = this.deleteCluster.shift();
        t && (this.explosionBoard.addExplosion(t.x, t.y, t.color), t.kill(), game.sfx.play("pop")), 0 == this.deleteCluster.length && this.checkVictory()
    }
}, Gam.BoardPuz.prototype.checkForFree = function() {
    for (o = 0; o < this.SIZEX; o++) this.bubbles[0][o] && (this.bubbles[0][o].cluster = !0, this.cluster.push(this.bubbles[0][o]));
    for (var t, e = 0; e < this.cluster.length;) t = this.cluster[e], e++, this.pushToClusterAllNeghbours(t.i, t.j);
    for (var s = 0, i = 0; i <= this.SIZEY; i++)
        for (var o = 0; o < this.SIZEX; o++) this.bubbles[i][o] && !this.bubbles[i][o].cluster && (this.deleteCluster.push(this.bubbles[i][o]), this.bubbles[i][o] = null, s++);
    return this.clearCluster(), s
}, Gam.BoardPuz.prototype.pushToClusterAllNeghbours = function(t, e) {
    e > 0 && this.bubbles[t][e - 1] && !this.bubbles[t][e - 1].cluster && (this.bubbles[t][e - 1].cluster = !0, this.cluster.push(this.bubbles[t][e - 1])), e < this.SIZEX - 1 && this.bubbles[t][e + 1] && !this.bubbles[t][e + 1].cluster && (this.bubbles[t][e + 1].cluster = !0, this.cluster.push(this.bubbles[t][e + 1])), t % 2 == 0 ? (t > 0 && (e > 0 && this.bubbles[t - 1][e - 1] && !this.bubbles[t - 1][e - 1].cluster && (this.bubbles[t - 1][e - 1].cluster = !0, this.cluster.push(this.bubbles[t - 1][e - 1])), this.bubbles[t - 1][e] && !this.bubbles[t - 1][e].cluster && (this.bubbles[t - 1][e].cluster = !0, this.cluster.push(this.bubbles[t - 1][e]))), t < this.SIZEY - 1 && (e > 0 && this.bubbles[t + 1][e - 1] && !this.bubbles[t + 1][e - 1].cluster && (this.bubbles[t + 1][e - 1].cluster = !0, this.cluster.push(this.bubbles[t + 1][e - 1])), this.bubbles[t + 1][e] && !this.bubbles[t + 1][e].cluster && (this.bubbles[t + 1][e].cluster = !0, this.cluster.push(this.bubbles[t + 1][e])))) : (t > 0 && (e < this.SIZEX - 1 && this.bubbles[t - 1][e + 1] && !this.bubbles[t - 1][e + 1].cluster && (this.bubbles[t - 1][e + 1].cluster = !0, this.cluster.push(this.bubbles[t - 1][e + 1])), this.bubbles[t - 1][e] && !this.bubbles[t - 1][e].cluster && (this.bubbles[t - 1][e].cluster = !0, this.cluster.push(this.bubbles[t - 1][e]))), t < this.SIZEY - 1 && (e < this.SIZEX - 1 && this.bubbles[t + 1][e + 1] && !this.bubbles[t + 1][e + 1].cluster && (this.bubbles[t + 1][e + 1].cluster = !0, this.cluster.push(this.bubbles[t + 1][e + 1])), this.bubbles[t + 1][e] && !this.bubbles[t + 1][e].cluster && (this.bubbles[t + 1][e].cluster = !0, this.cluster.push(this.bubbles[t + 1][e]))))
}, Gam.BoardPuz.prototype.removeCluster = function() {
    for (var t = 0; t < this.SIZEY; t++)
        for (var e = 0; e < this.SIZEX; e++) this.bubbles[t][e] && this.bubbles[t][e].cluster && (this.bubbles[t][e].cluster = !1, this.bubbles[t][e] = null, 0 == t && !0);
    this.deleteCluster.push.apply(this.deleteCluster, this.cluster);
    var s = this.cluster.length;
    return this.cluster.splice(0, this.cluster.length), s
}, Gam.BoardPuz.prototype.clearCluster = function() {
    for (var t = 0; t < this.SIZEY; t++)
        for (var e = 0; e < this.SIZEX; e++) this.bubbles[t][e] && this.bubbles[t][e].cluster && (this.bubbles[t][e].cluster = !1);
    this.cluster.splice(0, this.cluster.length)
}, Gam.BoardPuz.prototype.checkNext = function() {
    this.newX = this.movingBubble.x * this.movingBubble.dx * Gam.BUBBLEHALFWIDTH
}, Gam.BoardPuz.prototype.checkForCollisions = function() {
    if (this.movingBubble.y > Gam.BOARDY) return !1;
    if (this.movingBubble.y < Gam.BUBBLEHALFHEIGHT / 2) return !0;
    Math.floor(this.movingBubble.y / Gam.BUBBLEHEIGHT) % 2 ? Math.floor(this.movingBubble.x / Gam.BUBBLEWIDTH) >= this.SIZEX && this.SIZEX : Math.floor((this.movingBubble.x + Gam.BUBBLEHALFWIDTH) / Gam.BUBBLEWIDTH) >= this.SIZEX && this.SIZEX;
    for (var t = 0; t < this.SIZEY; t++)
        for (var e = 0; e < this.SIZEX; e++)
            if (this.bubbles[t][e]) {
                var s = Math.abs(this.bubbles[t][e].x - this.movingBubble.x),
                    i = Math.abs(this.bubbles[t][e].y - this.movingBubble.y);
                if (s < Gam.BUBBLEWIDTH && i < Gam.BUBBLEHEIGHT && Math.sqrt(s * s + i * i) < 50) return !0
            }
    return !1
}, Gam.BoardPuz.prototype.hasColor = function(t) {
    return this.mapColors(), this.colors.indexOf(t) > -1
}, Gam.BoardPuz.prototype.checkVictory = function() {
    for (var t = 0; t < this.SIZEX; t++)
        if (this.bubbles[0][t]) return !1;
    Gam.s.onLevelClear.dispatch()
}, Gam.BoardPuz.prototype.onRowDown = function() {
    this.movingDown = !0, this.rowDown = !1, this.targetY = this.y + Gam.BUBBLEHEIGHT, game.sfx.play("movedown")
}, Gam.BoardPuz.prototype.checkGameOver = function() {
    var t = this.SIZEY - this.fall;
    if (t < 0) return !0;
    for (var e = 0; e < this.SIZEX; e++)
        if (this.bubbles[t][e]) return this.gameOver(), !0;
    return !1
}, Gam.BoardPuz.prototype.gameOver = function() {
    game.gameMode = Gam.GameMode.PreGameOver;
    for (var t = this.SIZEY - this.fall; t >= 0; t--)
        for (var e = 0; e < this.SIZEX; e++) this.bubbles[t][e] && this.gameOverQueue.push(this.bubbles[t][e]);
    this.gameOverCounter = 0
}, Gam.BoardPuz.prototype.fixBubble = function() {
    var t = Math.floor(this.movingBubble.y / Gam.BUBBLEHEIGHT),
        e = 0;
    e = t % 2 ? Math.floor((this.movingBubble.x - Gam.BUBBLEHALFWIDTH) / Gam.BUBBLEWIDTH) : Math.floor(this.movingBubble.x / Gam.BUBBLEWIDTH), t < 0 && (t = 0), e < 0 && (e = 0), e >= this.SIZEX && (e = this.SIZEX - 1), null != this.bubbles[t][e] ? t == this.SIZEY ? this.gameOver() : (console.log(t + " " + e), this.movingBubble.kill(), this.movingBubble = null, game.p.onBall()) : (this.bubbles[t][e] = this.movingBubble, this.movingBubble.y = t * Gam.BUBBLEHEIGHT + Gam.BUBBLEHALFHEIGHT, this.movingBubble.x = t % 2 ? Gam.BUBBLEWIDTH * e + Gam.BUBBLEWIDTH : Gam.BUBBLEWIDTH * e + Gam.BUBBLEHALFWIDTH, this.movingBubble.i = t, this.movingBubble.j = e, this.movingBubble = null, this.checkForMatch(t, e), game.p.onBall())
}, Gam.Button = function(t, e, s, i, o, a) {
    if (Phaser.Button.call(this, game, t, e, null), s && Gam.loadTexture(this, s, "sprites"), this.anchor.setTo(.5), a) {
        var l = game.add.text(0, 0, a);
        l.font = "Roboto,Arial", l.fontSize = 24, l.fill = "#2B2B2B", l.anchor.set(.5), this.addChild(l)
    }
    this.onClick = new Phaser.Signal, i && this.onClick.add(i, o || this), this.onInputDown.add(this.click, this)
}, Gam.Button.prototype = Object.create(Phaser.Button.prototype), Gam.Button.constructor = Gam.Button, Gam.Button.prototype.click = function() {
    this.onClick.dispatch(), game.sfx.play("button")
}, Gam.AdsButton = function(t, e, s, i, o) {
    Phaser.Button.call(this, game, t, e, null, i, o), s && Gam.loadTexture(this, s, "sprites"), this.anchor.setTo(.5);
    var a = game.make.image(0, -20, "ui", "mov");
    a.anchor.set(.5), this.addChild(a);
    var l = game.make.text(0, 20, "skip level");
    l.font = "Roboto,Arial", l.fontSize = 31, l.fill = "#ffffff", l.anchor.set(.5), this.addChild(l), this.tint = 65280
}, Gam.AdsButton.prototype = Object.create(Phaser.Button.prototype), Gam.AdsButton.constructor = Gam.AdsButton, Gam.Dialog = function(t, e, s, i, o) {
    Phaser.Group.call(this, t), this.x = t.width / 2, this.y = 2 * t.height, this.opened = !1, o ? (this.bg = t.make.image(0, 0, "ui", o), this.bg.anchor.set(.5), this.add(this.bg)) : (i || (i = 0), this.bg = t.make.graphics(), this.add(this.bg), this.bg.lineStyle(3, 16777215, 1), i ? this.bg.beginFill(i, .9) : this.bg.beginFill(0, .8), this.bg.drawRoundedRect(-e / 2, -s / 2, e, s, 30)), this.showTween = t.add.tween(this).to({
        y: t.height / 2
    }, 500, Phaser.Easing.Linear.None, !1), this.hideTween = t.add.tween(this).to({
        y: 2 * t.height
    }, 500, Phaser.Easing.Linear.None, !1), this.hideTween.onComplete.add(this.closeEnd, this)
}, Gam.Dialog.prototype = Object.create(Phaser.Group.prototype), Gam.Dialog.prototype.open = function(t) {
    this.opened || (this.opened = !0, this.visible = !0, game.world.bringToTop(this), game.sfx.play("swish"), t ? this.y = game.height / 2 : (this.y = 2 * game.height, this.showTween.start()), Gam.s.onDialogOpen.dispatch())
}, Gam.Dialog.prototype.close = function(t) {
    this.opened && (this.opened = !1, game.sfx.play("swish"), t ? (this.visible = !1, this.y = 2 * game.height) : this.hideTween.start(), Gam.s.onDialogClose.dispatch())
}, Gam.Dialog.prototype.closeEnd = function() {
    this.visible = !1
}, Gam.RateDialog = function() {
    Gam.Dialog.call(this, game, 430, 480, 0);
    var t = game.add.text(0, -200, "Rate this game?");
    t.anchor.set(.5), this.add(t), t.font = Gam.Config.font, t.fontSize = 43, t.fill = "#00000", (t = game.add.text(0, -90, "Do you like this game? We need your feedback!")).anchor.set(.5), this.add(t), t.font = Gam.Config.font, t.fontSize = 30, t.wordWrap = !0, t.wordWrapWidth = 400, t.fill = "#ffffff";
    var e = new Gam.Button(0, 30, "button", function() {
        window.open("", "_system"), game.user.rate = !0, Gam.Local.saveUser(), ads = !1, this.close()
    }, this, "Rate");
    this.add(e);
    var s = new Gam.Button(0, 130, "button", function() {
        this.close()
    }, this, "Close");
    s.scale.set(.8), this.add(s), this.bg.y -= 30
}, Gam.RateDialog.prototype = Object.create(Gam.Dialog.prototype), Gam.SettingsDialog = function() {
    Gam.Dialog.call(this, game, 140, 325, 0);
    var s = new Gam.Button(0, 0, "menu", function() {
//        integration.showInterstitial(),
        game.state.start("Menu")
    }, this, "");
    this.add(s);
    var i = new Gam.Button(0, -100, "sound", function() {
        game.user.sound ? Gam.Config.sound = !1 : Gam.Config.sound = !0, game.user.sound = !game.user.sound, Gam.Local.saveUser()
    }, this, "");
    this.add(i);
    var l = new Gam.Button(0, 100, "no", function() {
        this.close()
    }, this, "");
    this.add(l)
}, Gam.SettingsDialog.prototype = Object.create(Gam.Dialog.prototype), Gam.SettingsDialog.constructor = Gam.SettingsDialog, Gam.ScoresDialog = function() {
    Gam.Dialog.call(this, game, 500, 400);
    var t = game.add.text(0, -190, "Your Top Scores");
    t.anchor.set(.5), t.font = Gam.Config.font, t.fontSize = 50, t.fill = "#ffffff", this.add(t), this.scores = [];
    for (var e = 0; e < 8; e++) {
        var s = game.add.text(0, 30 * e - 120, "000");
        s.anchor.set(.5), s.font = Gam.Config.font, s.fontSize = 30, s.fill = "#ffffff", this.add(s), this.scores[e] = s
    }
    this.x -= 50, this.bg.y -= 30;
    var i = new Gam.Button(0, 170, "button", function() {
        this.close()
    }, this, "Close");
    this.add(i), Gam.s.onScores.add(this.open, this)
}, Gam.ScoresDialog.prototype = Object.create(Gam.Dialog.prototype), Gam.ScoresDialog.prototype.constructor = Gam.ScoresDialog, Gam.ScoresDialog.prototype.open = function(t) {
    var e;
    for (e = 0; e < game.user.scores.length && e < this.scores.length; e++) this.scores[e].setText(game.user.scores[e]);
    Gam.Dialog.prototype.open.call(this)
}, Gam.LevelDialog = function() {
    Gam.Dialog.call(this, game, !1, !1, !1, "winner")
    Android.winDialog()

}, Gam.LevelDialog.prototype = Object.create(Gam.Dialog.prototype), Gam.LevelDialog.prototype.constructor = Gam.LevelDialog, Gam.VictoryDialog = function() {
    Gam.Dialog.call(this, game, 400, 300, 16777215);
    var t = game.add.text(0, -120, "You have finished all levels! Do you want to start again?");
    t.anchor.set(.5, 0), t.font = Gam.Config.font, t.fontSize = 35, t.fill = "#2B2B2B", t.stroke = "#80000000", t.wordWrap = !0, t.wordWrapWidth = 400, t.strokeThickness = 5, this.add(t);
    var e = new Gam.Button(0, 130, "button", function() {
        Gam.s.onRestart.dispatch(!0), integration.showInterstitial(), this.close()
    }, this, "OK");
    this.add(e)

    //game finished dialogs

}, Gam.VictoryDialog.prototype = Object.create(Gam.Dialog.prototype), Gam.VictoryDialog.prototype.constructor = Gam.VictoryDialog, Gam.GameOverDialog = function() {
    Gam.Dialog.call(this, game, !1, !1, !1, "loser")
    Android.LoserDialog()

}, Gam.GameOverDialog.prototype = Object.create(Gam.Dialog.prototype), Gam.GameOverDialog.prototype.constructor = Gam.GameOverDialog, Gam.LevelText = function() {
    Phaser.Text.call(this, game, 240, game.height / 3, "", {
        fill: "#ffffff",
        align: "center"
    }), this.anchor.set(.5), this.font = Gam.Config.font, this.fontSize = 1, this.fill = "", this.stroke = "", this.strokeThickness = 0, this.count = 0, this.visible = !1
}, Gam.LevelText.prototype = Object.create(Phaser.Text.prototype), Gam.LevelText.prototype.update = function() {
    this.visible && (this.count -= game.timeDiff, this.count < 0 && (this.visible = !1))
}, Gam.LevelText.prototype.show = function() {
    this.setText("Level " + game.level), this.visible = !0, this.count = 3e3
}, Gam.loadTexture = function(t, e, s) {
    s ? t.loadTexture(s, e) : t.loadTexture(e)
}, Gam.Menu = function(t) {}, Gam.Menu.prototype = {
    create: function() {
        this.stage.backgroundColor = game.add.image(0, 0, "bg"), this.title = game.add.image(240, 200, "ui", "shootbubble1"), this.title.anchor.set(.5), this.playButton = new Gam.Button(240, 600, "play", this.playGame, this), integration.showBanner(), game.add.existing(this.playButton)
    },
    playGame: function() {
        game.state.start("Game", !0, !1)
    },
    shutdown: function() {
        this.title.destroy(), this.playButton.destroy()
    }
}, Gam.GameMenu = function(t) {}, Gam.GameMenu.prototype = {
    create: function() {
        this.title = game.add.image(240, 200, "ui", "shootbubble1"), this.title.anchor.set(.5), this.playButton1 = new Gam.Button(240, 500, "button", this.playGame, this, "Puzzle"), game.add.existing(this.playButton1), this.playButton2 = new Gam.Button(240, 630, "button", function() {
            game.state.start("Game", !0, !1, "arcade")
        }, this, "Arcade"), game.add.existing(this.playButton2), this.editor = new Gam.Button(240, 690, "button", function() {
            game.state.start("Editor")
        }, this, "Editor"), this.editor.scale.set(.2), game.add.existing(this.editor), this.editor.visible = !1
    },
    playGame: function() {
        game.state.start("Game", !0, !1)
    },
    shutdown: function() {
        this.title.destroy(), this.playButton1.destroy(), this.playButton2.destroy()
    }
}, Gam.GameMode = {}, Gam.GameMode.Init = 1, Gam.GameMode.Play = 2, Gam.GameMode.Pause = 3, Gam.GameMode.GameOver = 4, Gam.GameMode.Level = 5, Gam.GameMode.Victory = 6, Gam.GameMode.PreGameOver = 7, Gam.Game = function(t) {
    this.scoreText, this.openDialogs, this.timeDiff = 0
}, Gam.Game.prototype = {
    init: function(t) {
        game.gameType = 1, "arcade" == t && (game.gameType = 2)
    },
    create: function() {
       this.count = 1, this.initInterface(), Gam.Config.android || game.input.addMoveCallback(this.mouseMove, this), game.input.onDown.add(this.onTouchDown, this), game.input.onUp.add(this.onTouchUp, this), this.touchDown = !1, game.p = this, Gam.s.onNewGame.add(this.onNewGame, this), Gam.s.onRestart.add(this.startGame, this), Gam.s.onNextLevel.add(this.nextLevel, this), Gam.s.onDialogOpen.add(this.onDialogOpen, this), Gam.s.onDialogClose.add(this.onDialogClose, this), Gam.s.onLevelClear.add(this.onLevelClear, this), Gam.s.onGameOver.add(this.gameOver, this), Gam.s.onScores.add(this.onScores, this), Gam.s.onSound.add(this.onSound, this), game.user.level > LEVELS.length ? this.victory() : this.startGame()
    },
    initInterface: function() {
        game.add.image(0, 0, "bg"), game.add.image(0, 644, "ui", "panel2"), 1 === game.gameType ? this.board = new Gam.BoardPuz : this.board = new Gam.Board, game.add.existing(this.board), this.arrow = game.add.image(240, 680, "bubbles", "arrow"), this.arrow.anchor.set(.5, 1), this.cursorBubble = new Gam.Bubble(240, 680, 1), game.add.existing(this.cursorBubble), this.previewBubble = new Gam.Bubble(240, 740, 1), game.add.existing(this.previewBubble), game.timeDiff = 0;
        var t = new Gam.Button(440, 760, "settings", function() {
            this.onSettings()
        }, this);
        game.add.existing(t), this.levelText = game.add.text(99, 678, "Level 0"), this.levelText.font = Gam.Config.font, this.levelText.fontSize = 28, this.levelText.stroke = "#813e18", this.levelText.strokeThickness = 0, this.levelText.fill = "#ffffff", this.levelText.anchor.set(.5), this.scoreText = game.add.text(379, 678, "Score 0"), this.scoreText.font = Gam.Config.font, this.scoreText.fontSize = 1, this.scoreText.stroke = "#813e18", this.scoreText.strokeThickness = 0, this.scoreText.fill = "#ffffff", this.scoreText.anchor.set(.5), this.levelStartText = new Gam.LevelText, game.add.existing(this.levelStartText), this.adsButton = new Gam.AdsButton(80, 740, "button", this.onAds, this), this.adsButton.scale.set(.7), game.add.existing(this.adsButton), this.adsButton.visible = !1
    },
    startGame: function(t) {
        this.clear(), game.gameMode = Gam.GameMode.Play, game.timeDiff = 0, 1 === game.gameType ? game.level = game.user.level : game.level = game.user.arcadeLevel, t && (game.level = 1, 1 == game.gameType ? game.user.level = 1 : game.user.arcadeLevel = 1, Gam.Local.saveUser()), this.board.restart(), this.currentRotation = 0, this.cursorBubble.setColor(this.board.getPreviewColor()), this.cursorBubble.visible = !0, this.previewBubble.setColor(this.board.getPreviewColor()), game.gameMode = Gam.GameMode.Play, this.lastTime = 0, this.openDialogs = 0, this.touchDown = !1, game.rowsPerLevel = 3, this.timeBonus = 1e6, this.scoreText.setText(game.user.score.toString()),  Android.levelUpdate(game.level), this.levelText.setText("  " + ""), game.user.plays++, Gam.Local.saveUser(),  this.levelStartText.show()
    },
    onAds: function() {
     this.nextLevel()
    },
    onRate: function() {
        this.rate = new Gam.RateDialog, game.add.existing(this.rate), this.rate.open(), game.rate = !0
    },
    nextLevel: function() {
     this.clear(), this.count++, game.level++, 1 == game.gameType ? game.user.level = game.level : game.user.arcadeLevel = game.level, Gam.Local.saveUser(), game.gameMode = Gam.GameMode.Play, game.timeDiff = 0, this.board.restart(), this.currentRotation = 0, this.cursorBubble.setColor(this.board.getPreviewColor()), this.cursorBubble.visible = !0, this.previewBubble.setColor(this.board.getPreviewColor()), game.gameMode = Gam.GameMode.Play, this.lastTime = 0, this.openDialogs = 0, this.touchDown = !1, game.rowsPerLevel = 3, this.timeBonus = 1e6, 1 == game.gameType ? this.scoreText.setText(game.user.score.toString()) : this.scoreText.setText(game.user.arcadeScore.toString()),  Android.levelUpdate(game.level), this.levelText.setText("  " + ""),  this.levelStartText.show()
    },
    restartLevel: function() {
        this.clear(), game.gameMode = Gam.GameMode.Play, game.timeDiff = 0, this.board.restart(), this.currentRotation = 0, this.cursorBubble.setColor(this.board.getPreviewColor()), this.cursorBubble.visible = !0, this.previewBubble.setColor(this.board.getPreviewColor()), game.gameMode = Gam.GameMode.Play, this.lastTime = 0, this.openDialogs = 0, this.touchDown = !1, game.rowsPerLevel = 3, this.timeBonus = 1e6, 1 == game.gameType ? this.scoreText.setText(game.user.score.toString()) : this.scoreText.setText(game.user.arcadeScore.toString()), Android.levelUpdate(game.level), this.levelText.setText("  " + ""),  this.levelStartText.show()
    },
    onBall: function() {
        this.cursorBubble.visible = !0, this.board.hasColor(this.previewBubble.color) ? this.cursorBubble.setColor(this.previewBubble.color) : this.cursorBubble.setColor(this.board.getPreviewColor()), this.previewBubble.setColor(this.board.getPreviewColor())
    },
    onNew: function() {
        this.newGameDialog.open()
    },
    onMenu: function() {
        this.settingsDialog.open()
    },
    onPoints: function(t) {
        var e = 10 * t;
        t > 9 ? e *= 2 : t > 5 ? e = Math.floor(1.5 * e) : t > 3 && (e += 10), 1 == game.gameType ? this.scoreText.setText(game.user.score.toString()) : (game.user.arcadeScore += e, this.scoreText.setText(game.user.arcadeScore.toString()))
        Android.gameScourUpdate(game.user.arcadeScore.toString())
    },
    onDialogOpen: function() {
        this.openDialogs++, game.gameMode === Gam.GameMode.Play && (game.gameMode = Gam.GameMode.Pause)
    },
    onDialogClose: function() {
        this.openDialogs--, this.openDialogs <= 0 && game.gameMode === Gam.GameMode.Pause && (game.gameMode = Gam.GameMode.Play), this.touchDown = !1
    },
    onSound: function() {
        game.user.sound ? Gam.loadTexture(this.soundButton, "soundon", "all") : Gam.loadTexture(this.soundButton, "soundoff", "all")
    },
    onSettings: function() {
       // this.settingsDialog || (this.settingsDialog = new Gam.SettingsDialog, game.add.existing(this.settingsDialog)), this.settingsDialog.open()
    },
    onScores: function() {
        this.scoresDialog || (this.scoresDialog = new Gam.ScoresDialog, game.add.existing(this.scoresDialog)), this.scoresDialog.open()
    },
	update: function() {
        this.now = Date.now(), game.timeDiff = this.now - this.lastTime, this.lastTime = this.now, game.gameMode == Gam.GameMode.Play && (this.timeBonus -= game.timeDiff, this.touchDown && this.rotateArrow(game.input.x, game.input.y))
    },
    onNewGame: function() {
        this.newGameDialog || (this.newGameDialog = new Gam.NewGameDialog), this.newGameDialog.open()
    },
    onLevelClear: function() {
        integration.showInterstitial(), game.gameMode = Gam.GameMode.Level, Gam.Local.saveUser(), 1 == game.gameType && game.level >= LEVELS.length ? this.victory() : (this.levelDialog || (this.levelDialog = new Gam.LevelDialog, game.add.existing(this.levelDialog)), this.levelDialog.open(), Gam.Config.android && !game.user.rate && !game.rate && this.count > 8 && game.time.events.add(1 * Phaser.Timer.SECOND, this.onRate, this))
    },
    shutdown: function() {
        this.levelDialog && (this.levelDialog.destroy(!0), this.levelDialog = null), this.gameOverDialog && (this.gameOverDialog.destroy(!0), this.gameOverDialog = null), this.settingsDialog && (this.settingsDialog.destroy(!0), this.settingsDialog = null), this.board.clear(), this.board.dest(), this.board.destroy(!0)
    },
    clear: function() {},
    checkGameOver: function() {},
    gameOver: function(t) {
        game.gameMode = Gam.GameMode.GameOver, this.gameOverDialog || (this.gameOverDialog = new Gam.GameOverDialog, integration.showInterstitial(), game.add.existing(this.gameOverDialog)), this.gameOverDialog.open()
    },
    victory: function() {
        game.gameMode = Gam.GameMode.Victory, this.victoryDialog || (this.victoryDialog = new Gam.VictoryDialog, game.add.existing(this.victoryDialog)), this.victoryDialog.open()
    },
    mouseMove: function(t) {
        game.gameMode == Gam.GameMode.Play && this.rotateArrow(t.x, t.y)
    },
    rotateArrow: function(t, e) {
        this.currentRotation = game.math.angleBetween(this.arrow.x, this.arrow.y, t, e), this.arrow.rotation = this.currentRotation + Math.PI / 2
    },
    onTouchUp: function(t) {
        return game.gameMode === Gam.GameMode.Level ? (this.levelDialog.close(), void this.nextLevel()) : game.gameMode === Gam.GameMode.GameOver ? (this.gameOverDialog.close(), void this.restartLevel()) : void(game.gameMode == Gam.GameMode.Play && (this.rotateArrow(t.x, t.y), t.y > 670 || (this.touchDown && this.cursorBubble.visible && this.board.fireBall(this.currentRotation, this.cursorBubble.color) && (this.cursorBubble.visible = !1), this.touchDown = !1)))
    },
    onTouchDown: function(t) {
        game.gameMode == Gam.GameMode.Play && (this.touchDown = !0, this.rotateArrow(t.x, t.y))
    }
};


function gameStart(){
    game.state.start("Game", !0, !1)

}



function arcadeGame(){
    game.state.start("Game", !0, !1, "arcade")
}


function gameMode1(){
    this.stage.backgroundColor = game.add.image(0, 0, "bg"), this.title = game.add.image(240, 200, "ui", "shootbubble1"), this.title.anchor.set(.5), this.playButton = new Gam.Button(240, 600, "play", this.playGame, this), integration.showBanner(), game.add.existing(this.playButton)

}


function gameMode2(){
    game.add.image(0, 0, "bg"), game.add.image(0, 644, "ui", "panel2"), 1 === game.gameType ? this.board = new Gam.BoardPuz : this.board = new Gam.Board, game.add.existing(this.board), this.arrow = game.add.image(240, 680, "bubbles", "arrow"), this.arrow.anchor.set(.5, 1), this.cursorBubble = new Gam.Bubble(240, 680, 1), game.add.existing(this.cursorBubble), this.previewBubble = new Gam.Bubble(240, 740, 1), game.add.existing(this.previewBubble), game.timeDiff = 0;
    var t = new Gam.Button(440, 760, "settings", function() {
        this.onSettings()
    }, this);
    game.add.existing(t), this.levelText = game.add.text(99, 678, "Level 0"), this.levelText.font = Gam.Config.font, this.levelText.fontSize = 28, this.levelText.stroke = "#813e18", this.levelText.strokeThickness = 0, this.levelText.fill = "#ffffff", this.levelText.anchor.set(.5), this.scoreText = game.add.text(379, 678, "Score 0"), this.scoreText.font = Gam.Config.font, this.scoreText.fontSize = 1, this.scoreText.stroke = "#813e18", this.scoreText.strokeThickness = 0, this.scoreText.fill = "#ffffff", this.scoreText.anchor.set(.5), this.levelStartText = new Gam.LevelText, game.add.existing(this.levelStartText), this.adsButton = new Gam.AdsButton(80, 740, "button", this.onAds, this), this.adsButton.scale.set(.7), game.add.existing(this.adsButton), this.adsButton.visible = !1


}

function gameMode3(){
    var s = new Gam.Button(0, 0, "menu", function() {
        //        integration.showInterstitial(),
                game.state.start("Menu")
            }, this, "");
            this.add(s);
            var i = new Gam.Button(0, -100, "sound", function() {
                game.user.sound ? Gam.Config.sound = !1 : Gam.Config.sound = !0, game.user.sound = !game.user.sound, Gam.Local.saveUser()
            }, this, "");
            this.add(i);
            var l = new Gam.Button(0, 100, "no", function() {
                this.close()
            }, this, "");
            this.add(l)
}

function dialogClsoe(){
      game.state.start("Game", !0, !1)

}

function gamelevelUpdate(){
      game.state.start("Game", !0, !1)
    this.count++, game.level++, 1 == game.gameType ? game.user.level = game.level : game.user.arcadeLevel = game.level, Gam.Local.saveUser(), game.gameMode = Gam.GameMode.Play, game.timeDiff = 0, this.board.restart(), this.currentRotation = 0, this.cursorBubble.setColor(this.board.getPreviewColor()), this.cursorBubble.visible = !0, this.previewBubble.setColor(this.board.getPreviewColor()), game.gameMode = Gam.GameMode.Play, this.lastTime = 0, this.openDialogs = 0, this.touchDown = !1, game.rowsPerLevel = 3, this.timeBonus = 1e6, 1 == game.gameType ? this.scoreText.setText(game.user.score.toString()) : this.scoreText.setText(game.user.arcadeScore.toString()), this.levelText.setText("Level " + game.level),  this.levelStartText.show()

}
function gamelevelUpdateArcade(){
         game.state.start("Game", !0, !1, "arcade")
    this.count++, game.level++, 1 == game.gameType ? game.user.level = game.level : game.user.arcadeLevel = game.level, Gam.Local.saveUser(), game.gameMode = Gam.GameMode.Play, game.timeDiff = 0, this.board.restart(), this.currentRotation = 0, this.cursorBubble.setColor(this.board.getPreviewColor()), this.cursorBubble.visible = !0, this.previewBubble.setColor(this.board.getPreviewColor()), game.gameMode = Gam.GameMode.Play, this.lastTime = 0, this.openDialogs = 0, this.touchDown = !1, game.rowsPerLevel = 3, this.timeBonus = 1e6, 1 == game.gameType ? this.scoreText.setText(game.user.score.toString()) : this.scoreText.setText(game.user.arcadeScore.toString()), this.levelText.setText("Level " + game.level),  this.levelStartText.show()

}

function DialogCloseArcade(){
         game.state.start("Game", !0, !1, "arcade")

}

function loserOption(){
  game.state.start("Game", !0, !1)
}
function loserOptionArcade(){
          game.state.start("Game", !0, !1, "arcade")
}
